% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/journeys.r
\name{fnc}
\alias{fnc}
\title{Find next cell function}
\usage{
fnc(rdmap, tm, curInd, mom = NULL, momAdj = 0.5, w1 = exp(1), w2 = 1,
  varEst = 10)
}
\arguments{
\item{rdmap}{reduced dimensionality matrix with cells in rows and dims in columns}

\item{tm}{Transition matrix}

\item{curInd}{Current state on tm}

\item{mom}{Current momentum vector}

\item{momAdj}{Weighting to adjust momentum. From 0-1. Lower numbers make smaller
adjustment to momentum vector.}

\item{w1}{Parameter - Base used for modifying of tm probs.}

\item{w2}{Parameter - Multiplifaction factor used for modifying tm probs.}

\item{varEst}{Number of alternatives to sample for estimating variance.}
}
\value{
Returns index of new cell and new momentum vector
}
\description{
Find next cell function
}
\details{
Find next cell function. Transitioin probabilities are modifed by calulating the cosine
of the angle between the current momentum vector and the vector on the rdmap required for
each transtion. The tranisiton probability is adjusted by multiplying by w1^(w2 * (cosine_angle)) and then normalising.
}
\examples{
\dontrun{
nextCell <- fnc(rdmap, tm, curInd)
}
}
\author{
Wajid Jawaid
}
