% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/butterfly_put.R
\name{butterfly.put}
\alias{butterfly.put}
\title{Butterfly Put Spread Strategy Function}
\usage{
butterfly.put(
  k1,
  k2,
  k3,
  p1,
  p2,
  p3,
  spread = c("long", "short"),
  llimit = 20,
  ulimit = 20
)
}
\arguments{
\item{k1}{Excercise Price of 1st Long Put Option (Long Spread)/ Excercise Price of 1st Short Put Option (Short Spread)}

\item{k2}{Excercise Price of Short Put Option (Long Spread) / Excercise Price of Long Put Option (Short Spread)}

\item{k3}{Excercise Price of 2nd Long Put Option (Long Spread) / Excercise Price of 2nd Short Put Option (Short Spread)}

\item{p1}{Premium of 1st Long Put Option (Long Spread)/ Premium of 1st Short Put Option (Short Spread)}

\item{p2}{Premium of Short Put Option (Long Spread) / Premium of Long Put Option (Short Spread)}

\item{p3}{Premium of 2nd Long Put Option (Long Spread) / Premium of 2nd Short Put Option (Short Spread)}

\item{spread}{Type of Spread, Default: c("long", "short")}

\item{llimit}{Lower limit of stock price at Expiration., Default: 20}

\item{ulimit}{Upper Limit of Stock Price at Expiration, Default: 20}
}
\value{
OUTPUT_DESCRIPTION Returns the profit/loss generated from the strategy along with the profit/loss of individual contract and an interactive graph for the same.
}
\description{
This function can be used to develop a Butterfly Put Spread Strategy
}
\details{
The long put butterfly spread is created by buying one put with a lower strike price, selling two at-the-money puts, and buying a put with a higher strike price. Net debt is created when entering the position. The short put butterfly spread is created by writing one out-of-the-money put option with a low strike price, buying two at-the-money puts, and writing an in-the-money put option at a higher strike price.
}
\examples{
butterfly.put(100, 105, 95, 2.2, 3.2, 1.25, spread = 'long')
}
