% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/planes.R
\name{plane_diff}
\alias{plane_diff}
\title{Difference component}
\usage{
plane_diff(location, input, seed)
}
\arguments{
\item{location}{Character vector with location code; the location must appear in input and seed}

\item{input}{Input signal data to be scored; object must be one of \link[=to_signal]{forecast} or \link[=to_signal]{observed}}

\item{seed}{Prepared \link[=plane_seed]{seed}}
}
\value{
A \code{list} with the following values:
\itemize{
\item \strong{indicator}: Logical as to whether or not the absolute value of any of the evaluated differences exceeds the maximum difference
\item \strong{values}: A vector with the values assessed including the last value in seed concatenated with the evaluated signal values
\item \strong{evaluated_differences}: A vector with the consecutive differences for the values
\item \strong{maximum_difference}: A vector with one value for the maximum difference observed in seed
}
}
\description{
This function implements the point-to-point difference plausibility component. Differences in evaluated signals are calculated from input values iteratively subtracted from the previous values (i.e., for each x at time point i, the difference will be calculated as xi - xi-1). The plausibility analysis uses the evaluated differences to compare against the maximum difference observed and recorded in the seed.
}
\examples{
## read in example observed data and prep observed signal
hosp <- read.csv(system.file("extdata/observed/hdgov_hosp_weekly.csv", package = "rplanes"))
hosp$date <- as.Date(hosp$date, format = "\%Y-\%m-\%d")
prepped_observed <- to_signal(hosp, outcome = "flu.admits", type = "observed", resolution = "weeks")

## read in example forecast and prep forecast signal
fp <- system.file("extdata/forecast/2022-10-31-SigSci-TSENS.csv", package = "rplanes")
prepped_forecast <- read_forecast(fp) \%>\%
  to_signal(., outcome = "flu.admits", type = "forecast", horizon = 4)

## prepare seed with cut date
prepped_seed <- plane_seed(prepped_observed, cut_date = "2022-10-29")

## run plane component
plane_diff(location = "10", input = prepped_forecast, seed = prepped_seed)
plane_diff(location = "51", input = prepped_forecast, seed = prepped_seed)

}
