% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AssessmentItem.R, R/AssessmentTest.R,
%   R/character.R
\docType{methods}
\name{createQtiTest-methods}
\alias{createQtiTest-methods}
\alias{createQtiTest}
\alias{createQtiTest,AssessmentItem-method}
\alias{createQtiTest,AssessmentItem}
\alias{createQtiTest,AssessmentTest-method}
\alias{createQtiTest,AssessmentTest}
\alias{createQtiTest,character-method}
\alias{createQtiTest,character}
\title{Create zip-archive of the qti test specification}
\usage{
createQtiTest(object, dir = NULL, verification = FALSE, zip_only =
  FALSE)

\S4method{createQtiTest}{AssessmentItem}(object, dir = ".", verification = FALSE, zip_only = FALSE)

\S4method{createQtiTest}{AssessmentTest}(object, dir = getwd(), verification = FALSE, zip_only = FALSE)

\S4method{createQtiTest}{character}(object, dir = getwd())
}
\arguments{
\item{object}{An instance of the \link{AssessmentTest}, \link{AssessmentTestOpal} or
\link{AssessmentItem} S4 object.}

\item{dir}{A character value, optional; a folder to store xml file; working
directory is used by default.}

\item{verification}{A boolean value, optional; to check validity of xml
files. Default is \code{FALSE}.}

\item{zip_only}{A boolean value, optional; returns only zip file in case of
\code{TRUE} or zip, xml and downloads files in case of \code{FALSE} value. Default is
\code{FALSE}.}
}
\value{
A path to zip and xml files.
}
\description{
Create zip-archive of the qti test specification
}
\examples{
essay <- new("Essay", prompt = "Test task", title = "Essay",
             identifier = "q1")
sc <- new("SingleChoice", prompt = "Test task", title = "SingleChoice",
          choices = c("A", "B", "C"), identifier = "q2")
exam_section <- new("AssessmentSection", identifier = "sec_id",
                   title = "section", assessment_item = list(essay, sc))
exam <- new("AssessmentTestOpal", identifier = "id_test",
           title = "some title", section = list(exam_section))
\dontrun{
# creates folder with zip (side effect)
createQtiTest(exam, "exam_folder", "TRUE")
}
}
