% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMS.R, R/Opal.R
\name{getCourseElements}
\alias{getCourseElements}
\alias{getCourseElements,missing-method}
\alias{getCourseElements,Opal-method}
\title{Get elements of the course by courseId from LMS}
\usage{
getCourseElements(object, course_id)

\S4method{getCourseElements}{missing}(object, course_id)

\S4method{getCourseElements}{Opal}(object, course_id)
}
\arguments{
\item{object}{An S4 object of class \link{Opal} that represents a connection to the LMS.}

\item{course_id}{A length one character vector with course id.}
}
\value{
A dataframe with the elements of the course.

A dataframe with the data of the elements of the course (fields: nodeId,
shortTitle, shortName, longTitle) on LMS Opal.
}
\description{
This method gets elements of the user's course by its courseId on Learning Management System (LMS).
If no LMS connection object is provided, it attempts to guess the connection using default settings (e.g., environment variables).
If the connection cannot be established, an error is thrown.
}
