% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrr.R
\name{rank_trace}
\alias{rank_trace}
\title{Rank Trace Plot}
\usage{
rank_trace(x, y, type = "identity", k = 0, plot = TRUE,
  interactive = FALSE)
}
\arguments{
\item{x}{data frame or matrix of predictor variables}

\item{y}{data frame or matrix of response variables}

\item{type}{type of reduced-rank regression model to fit. \code{type = "identity"}, the default, uses \eqn{\mathbf{\Gamma} = \mathbf{I}} to fit a reduced-rank regression. \code{type = "pca"} fits a principal component analysis model as a special case of reduced-rank regression. \code{type = "cva"} fits a canonical variate analysis model as a special case of reduced-rank regression. \code{type = "lda"} fits a linear discriminant analysis model as a special case of reduced-rank regression.}

\item{k}{small constant added to diagonal of covariance matrices to make inversion easier.}

\item{plot}{if FALSE, returns data frame of rank trace coordinates.}

\item{interactive}{if TRUE, creates an interactive plotly graphic.}
}
\value{
plot of rank trace coordinates if \code{plot = TRUE}, the default, or data frame of rank trace coordinates if \code{plot = FALSE}.
}
\description{
\code{rank_trace} is a plot used to determine the effective dimensionality, i.e., \eqn{t = \mathrm{rank}\left(\mathbf{C}\right)},
of the reduced-rank regression equation.
}
\examples{
data(tobacco)
tobacco_x <- tobacco[,4:9]
tobacco_y <- tobacco[,1:3]
gamma <- diag(1, dim(tobacco_y)[2])
rank_trace(tobacco_x, tobacco_y)
rank_trace(tobacco_x, tobacco_y, plot = FALSE)
rank_trace(tobacco_x, tobacco_y, type = "cva")

data(pendigits)
digits_features <- pendigits[, -35:-36]
rank_trace(digits_features, digits_features, type = "pca")

library(dplyr)
data(COMBO17)
galaxy <- as_data_frame(COMBO17)
galaxy <- select(galaxy, -starts_with("e."), -Nr, -UFS:-IFD)
galaxy <- na.omit(galaxy)
galaxy_x <- select(galaxy, -Rmag:-chi2red)
galaxy_y <- select(galaxy, Rmag:chi2red)
rank_trace(galaxy_x, galaxy_y, type = "cva")

}
\references{
Izenman, A.J. (2008) \emph{Modern Multivariate Statistical Techniques}. Springer.
}

