% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsat_mosaic.R
\name{rsat_mosaic}
\alias{rsat_mosaic}
\alias{rsat_mosaic,rtoi-method}
\alias{rsat_mosaic,sf,character}
\alias{rsat_mosaic,records-method}
\alias{rsat_mosaic,records}
\title{Mosaic the tiles intersecting the region of interest}
\usage{
rsat_mosaic(x, ...)

\S4method{rsat_mosaic}{rtoi}(x, ...)

\S4method{rsat_mosaic}{records}(
  x,
  out_path,
  db_path,
  bfilter = c(),
  warp = "extent",
  region,
  overwrite = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{an \code{rtoi} object.}

\item{...}{additional arguments.}

\item{out_path}{path to save the mosaicked images. By default, the path
is defined by \code{x}.}

\item{db_path}{path to the database. By default, the path
is defined by \code{x}.}

\item{bfilter}{a vector of bands to. If not supplied, all are used.}

\item{warp}{character. If equal to "extent", it also crops the images
around the \code{rtoi}. Use "" otherwise.}

\item{region}{an sf object. Region for cropping the images around.
By default, the path is defined by \code{x}.}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing
images with the same name.}

\item{verbose}{boolean. If TRUE show verbose output. Default FALSE}
}
\value{
nothing. Mosaics the downloaded images and stored them on the hard disk
}
\description{
Satellite measurements are divided into indivisible units called tiles. The
mosaic function binds and crops the tiles to generate a single image
of the region of interest for each date.
}
\examples{
\dontrun{
library(rsat)

# load navarre sf from the package
data(ex.navarre)

# set the credentials
set_credentials("username", "password")

# path where the region is stored
rtoi.path <- tempdir()
# path where downloads are stored
db.path <- file.path(tempdir(), "DATABASE")
navarre <- new_rtoi(
  "Navarre",
  ex.navarre,
  rtoi.path,
  db.path
) #'
# Landsat-5
rsat_search(
  region = navarre,
  product = "LANDSAT_TM_C1",
  dates = as.Date("1988-08-01") + seq(1, 35)
)
rsat_download(navarre)

rsat_mosaic(navarre, overwrite = T)

rsat_list_data(navarre)
}

}
