% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.R
\name{parse_vpath}
\alias{parse_vpath}
\title{Parser for G* nodes paths.}
\usage{
parse_vpath(vpath)
}
\arguments{
\item{vpath}{A vector of character type, representing a path as a sequence of nodes. The nodes
are supposed to belong to an original graph G, but be written in terms of G*.}
}
\value{
A new vector of character type, representing the same path as \code{vpath} but with 
   the nodes names translated to the original graph G's names.
}
\description{
Translates a sequence of nodes from a G* graph, generated with any of the 
available transformations, to a sequence of nodes in terms of the original G.
}
\examples{
# Obtain the vpath from any way, an algorithm or random walk.
# Call the parsing function
translated_vpath <- parse_vpath( c("s|u", "s|u|v", "u|v|y", "t") )

# Print the result
translated_vpath


}
\seealso{
Other Parsers: \code{\link{direct_graph}},
  \code{\link{get_all_nodes}}
}
\concept{Parsers}
