% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_flextable_separators.R
\name{add_flextable_separators}
\alias{add_flextable_separators}
\title{Add Conditional Separators (horizontal line or padding) to \code{flextable} Rows}
\usage{
add_flextable_separators(
  ft,
  trailing_sep,
  border = officer::fp_border(width = 1, color = "grey60"),
  padding = 10
)
}
\arguments{
\item{ft}{A flextable object.}

\item{trailing_sep}{A vector specifying separators. Its length must equal
the number of rows in the body of \code{ft}. Allowed values are NA (no
separator), "-" (adds a horizontal line), or " " (adds bottom padding).}

\item{border}{The \code{fp_border} object to use for horizontal lines when
\code{trailing_sep} is "-". Defaults to a gray line of width 1.}

\item{padding}{The amount of bottom padding (in points) to add when
\code{trailing_sep} is " ". Defaults to 10.}
}
\value{
The modified flextable object, or the original \code{ft} if all
\code{trailing_sep} values are NA. Throws an error for invalid inputs or
invalid characters in \code{trailing_sep}.
}
\description{
Modifies an existing \code{flextable} object by adding visual separators
(horizontal lines or bottom padding) after specific rows based on a
control vector, without changing the table's row count.
}
\examples{
content <- data.frame(
  USUBJID = c("S1", "S1", "S1", "S2", "S2", "S2", "S3"),
  ARM = c("A", "A", "B", "A", "A", "B", "A"),
  VAL = round(rnorm(7), 2)
)
ft <- flextable::as_flextable(content)
ft <- flextable::theme_booktabs(ft)

# Define separators: line, space, NA, line, space, NA, NA
sep_ctrl <- c("-", " ", NA, "-", " ", NA, NA)

ft_modified <- add_flextable_separators(ft, sep_ctrl)
print(ft_modified)

# Example: All NA - should return original ft
ft_all_na <- add_flextable_separators(ft, rep(NA, 7))
identical(ft, ft_all_na) # Should be TRUE

# Example: Invalid character - should throw error
tryCatch(
  add_flextable_separators(ft, c("-", "x", NA, "-", " ", NA, NA)),
  error = function(e) print(e)
)

}
