% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{set_formatter_tick_cross}
\alias{set_formatter_tick_cross}
\title{Set tick cross formatter}
\usage{
set_formatter_tick_cross(widget, column, hoz_align = "center")
}
\arguments{
\item{widget}{A \code{\link[=tabulator]{tabulator()}} HTML widget.}

\item{column}{The name of the column the formatter is applied to.}

\item{hoz_align}{(character): The horizontal alignment of the column.}
}
\value{
The updated \code{\link[=tabulator]{tabulator()}} HTML widget
}
\description{
Set tick cross formatter
}
\examples{
data <- data.frame(
  Artist = c("Art Blackey", "Nirvana", "Bob Marley"),
  Grunge = c(0, 1, 0),
  Jazz = c(1, 0, 0),
  Reggae = c(0, 0, 1)
)

tabulator(data, width = 400) |>
  set_formatter_tick_cross("Grunge") |>
  set_formatter_tick_cross("Jazz") |>
  set_formatter_tick_cross("Reggae")
}
