% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsBrukerMCFReader.R
\name{reopen.rtmsBrukerMCFReader}
\alias{reopen.rtmsBrukerMCFReader}
\alias{close.rtmsBrukerMCFReader}
\alias{closeBrukerMCFReader}
\alias{reopenBrukerMCFReader}
\title{Manage an MCF reader file connection}
\usage{
\method{reopen}{rtmsBrukerMCFReader}(x, ...)

\method{close}{rtmsBrukerMCFReader}(con, ...)

closeBrukerMCFReader(reader)

reopenBrukerMCFReader(reader)
}
\arguments{
\item{x}{The reader object to reopen}

\item{...}{Included for S3 compatibility}

\item{con}{The reader object to be closed}

\item{reader}{An RTMS reader object of class \code{rtmsBrukerMCFReader}}
}
\value{
The same reader object with a closed connection
}
\description{
Closes the open connection to the main data file in a Bruker MCF reader
object.
}
\details{
Because Bruker MCF directories contain a potentially large number of
spectra, reopening a connection to the main data file when reading many
spectra or samples from it is inefficient and slow, especially if the file
is being accessed over a network connection.  The \code{rtmsBrukerMCFReader}
object therefore maintains an open connection to the main binary data file
until it is closed by the user. Of course, the reader object still maintains
all the index and calibration data, making it possible to reopen a
connection to the MCF directory without all the preprocessing required when
first opening.  Unfortunately, taking advantage of this fact is a little
tricky.

In most cases, R is a functional language, with limited side effects on R
objects; so it is difficult to alter the state of reader object without
returning it explicitly.  However, one of the few cases where side-effects
are quite important is R's management of open file connections, with
functions like \code{close}.  Thus, calling \code{closeBrukerMCFReader} (and the S3
function \code{close} which wraps it) will in fact close the connection, but will
not return an altered copy of the reader object reflecting that it is
closed.  So if the user wishes to close a reader object with the possibility
of reopening it, they must close the reader AND assign the returned reader
object to the relevant name.  This will store the fact the connection has
been closed, and allow the \code{reopen} function to operate correctly.
}
\section{Functions}{
\itemize{
\item \code{reopen(rtmsBrukerMCFReader)}: The S3 method \code{close} for objects of class
\code{rtmsBrukerMCFReader}; calls \code{closeBrukerMCFReader}

\item \code{close(rtmsBrukerMCFReader)}: The S3 method \code{reopen} for objects of class
\code{rtmsBrukerMCFReader}; calls \code{reopenBrukerMCFReader}

\item \code{reopenBrukerMCFReader()}: Reopens a file connection to the main
binary data file in a Bruker MCF directgry so that data can be extracted

}}
