% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsSpectrum.R
\name{getSample.rtmsSpectrum}
\alias{getSample.rtmsSpectrum}
\alias{getSampleFromSpectrum}
\title{Extract a sample from an RTMS spectrum object}
\usage{
\method{getSample}{rtmsSpectrum}(x, peaks, ...)

getSampleFromSpectrum(spectrum, peaks, freqSpacing = TRUE, threshold = NULL)
}
\arguments{
\item{x}{The spectrum object}

\item{peaks}{A list of peak objects of class \code{rtmsPeak}}

\item{...}{Additional parameters}

\item{spectrum}{A full spectrum of class \code{rtmsSpectrum}}

\item{freqSpacing}{If TRUE (the default), local maxima (estimated via
quadratic interpolation) are calculated in inverse m/z (or frequency) space,
as in FTMS spectra.  If FALSE, maxima are calculated directy in m/z space}

\item{threshold}{If NULL, all local maxima will be returned for each
subsample; if set to particular value, only those maxima above that threshold
will be returned.}
}
\value{
An RTMS sample object of class \code{rtmsSample}
}
\description{
Extracts a sample object of class \code{rtmsSample} from a single spectrum object
of class \code{rtmsSample} usin g a list of peaks
}
\section{Functions}{
\itemize{
\item \code{getSample(rtmsSpectrum)}: The S3 method \code{getSample} for objects
of class \code{rtmsSpectrum}; calls \code{getSampleFromSpectrum}

}}
\examples{
peaks <- rtmsPeakList(c(1516.83,1530.84),peakWidth=0.2,windowWidth = c(5,10))
names(peaks) <- c("Product","Substrate")
sample <- getSample(exampleSpectrum,peaks)
}
