% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsSample.R
\name{sampleAndSampleSet}
\alias{sampleAndSampleSet}
\alias{[.rtmsSampleSet}
\alias{[[.rtmsSampleSet}
\alias{[[<-.rtmsSampleSet}
\alias{rep.rtmsSampleSet}
\alias{rep.rtmsSample}
\title{Functions for creating and manipulating samples and sample sets}
\usage{
\method{[}{rtmsSampleSet}(x, i, ...)

\method{[[}{rtmsSampleSet}(x, i, ...)

\method{[[}{rtmsSampleSet}(x, i) <- value

\method{rep}{rtmsSampleSet}(x, ...)

\method{rep}{rtmsSample}(x, ...)
}
\arguments{
\item{x}{An object of class \code{rtmsSample}}

\item{i}{A single numeric index of the sample set}

\item{...}{Included for S3 compatibility}

\item{value}{An object of class \code{rtmsSample}}
}
\value{
An object of class \code{rtmsSampleSet}

An object of class \code{rtmsSample}

An object of class \code{rtmsSampleSet}

An object of class \code{rtmsSampleSet}

An object of class \code{rtmsSampleSet}
}
\description{
Select a subset of a sample set (returns an \code{rtmsSampleSet})
}
\details{
The sample (class \code{rtmsSample}) and sample set (class \code{rtmsSampleSet})
objects are the core structures used to extract meaningful data from mass
spectographic data.  In general, samples and sample sets will be created
automatically from other RTMS objects (such as readers or spectra) but in
the event that one wishes to manipulate them directly, it is important to
understand several details about how they work.

In terms of the data it contains, an object of class \code{rtmsSample} is just a
list of smaller objects (of class \code{rtmsSubsample}); however, each of these
subsamples corresponds to an \code{rtmsPeak} object that was used to extract it;
the \code{rtmsSample} object therefor has a "peaks" attribute, which is a list of
objects of class \code{rtmsPeak} corresponding to the subsamples in the
\code{rtmsSample} object.  This attribute is used to determine how measurements
of the sample are reported and how the sample is plotted.

Similarly, the data contained in an object of class \code{rtmsSampleSet} is just
a list of \code{rtmsSample} objects but with an important difference.  If many
\code{rtmsSample} objects were arranged into a list, there would be no guarantee
that they contain measurements of the same peaks; such guarantees are
essential for plotting sample sets together or constructing extracted ion
chromatograms.  The \code{rtmsSampleSet} therefore strips the "peaks" attribute
from its individual members, and applies a single shared "peaks" attribute
to the entire sample set.  Further samples can only be added to the sample
set if their peaks attributes are deemed compatible.
}
\section{Functions}{
\itemize{
\item \code{[[}: Select a single element of a sample set
(returns an \code{rtmsSample})

\item \code{`[[`(rtmsSampleSet) <- value}: Insert a sample into a sample set

\item \code{rep(rtmsSampleSet)}: Repeat a sample set multiple times

\item \code{rep(rtmsSample)}: Create a sample set by repeating a single
sample (returns an \code{rtmsSampleSet})

}}
