% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lists.R
\name{get_list_accounts}
\alias{get_list_accounts}
\title{View accounts in a list}
\usage{
get_list_accounts(
  id,
  limit = 40L,
  token = NULL,
  parse = TRUE,
  retryonratelimit = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{id}{character, id of the list}

\item{limit}{integer, number of records to return}

\item{token}{bearer token created with \link{create_token}}

\item{parse}{logical, if \code{TRUE}, the default, returns a tibble. Use \code{FALSE}  to return the "raw" list corresponding to the JSON returned from the Mastodon API}

\item{retryonratelimit}{If TRUE, and a rate limit is exhausted, will wait until it refreshes. Most Mastodon rate limits refresh every 5 minutes. If FALSE, and the rate limit is exceeded, the function will terminate early with a warning; you'll still get back all results received up to that point.}

\item{verbose}{logical, whether to display messages}
}
\value{
a tibble or list of accounts
}
\description{
View accounts in a list
}
\examples{
\dontrun{
get_list_accounts(id = "test")
}
}
