% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{DAGM_2M_long_run}
\alias{DAGM_2M_long_run}
\title{DAGM-2M (daily) long-run volatility (with skewness)}
\usage{
DAGM_2M_long_run(param, daily_ret, mv_m_1, mv_m_2, K_1, K_2, lag_fun = "Beta")
}
\arguments{
\item{param}{Vector of starting values.}

\item{daily_ret}{Daily returns, which must be an "xts" object.}

\item{mv_m_1}{first MIDAS variable already transformed into a matrix, through \code{\link{mv_into_mat}} function.}

\item{mv_m_2}{second MIDAS variable already transformed into a matrix, through \code{\link{mv_into_mat}} function.}

\item{K_1}{Number of (lagged) realizations of the first MIDAS variable to consider.}

\item{K_2}{Number of (lagged) realizations of the second MIDAS variable to consider.}

\item{lag_fun}{\strong{optional}. Lag function to use. Valid choices are "Beta" (by default) and "Almon",
for the Beta and Exponential Almon lag functions, respectively.}
}
\value{
The resulting vector is an "xts" object representing the long-run volatility.
}
\description{
Obtains the long-run volatility of the DAGM with two MIDAS variables.
For details, see \insertCite{amendola_candila_gallo:2019;textual}{rumidas}.
}
\examples{
\donttest{
start_val<-c(0.01,0.80,0.05,0.2,0.1,1.1,0.4,1.1,0.5,1.1,0,1.1)
r_t<-sp500['2005/2010']
mv_m_1<-mv_into_mat(r_t,diff(indpro),K=12,"monthly")
mv_m_2<-mv_into_mat(r_t,diff(indpro),K=24,"monthly")
head(DAGM_2M_long_run(start_val,r_t,mv_m_1,mv_m_2,K_1=12,K_2=24))
}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mv_into_mat}}.
}
\keyword{internal}
