% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dnorm_rvec}
\alias{dnorm_rvec}
\alias{pnorm_rvec}
\alias{qnorm_rvec}
\alias{rnorm_rvec}
\title{Normal Distribution, Using Multiple Draws}
\usage{
dnorm_rvec(x, mean = 0, sd = 1, log = FALSE)

pnorm_rvec(q, mean = 0, sd = 1, lower.tail = TRUE, log.p = FALSE)

qnorm_rvec(p, mean = 0, sd = 1, lower.tail = TRUE, log.p = FALSE)

rnorm_rvec(n, mean = 0, sd = 1, n_draw = NULL)
}
\arguments{
\item{x}{Quantiles. Can be an rvec.}

\item{mean}{Mean of distribution.
Default is \code{0}.  See \code{\link[=dnorm]{dnorm()}}.
Can be an rvec.}

\item{sd}{Standard deviation.
Default is \code{1}. See \code{\link[=dnorm]{dnorm()}}.
Can be an rvec.}

\item{log, log.p}{Whether to return results
on a log scale. Default is
\code{FALSE}. Cannot be an rvec.}

\item{q}{Quantiles. Can be an rvec.}

\item{lower.tail}{Whether to return
\eqn{P[X \le x]}, as opposed to
\eqn{P[X > x]}. Default is \code{TRUE}.
Cannot be an rvec.}

\item{p}{Probabilities. Can be an rvec.}

\item{n}{The length of random vector being
created. Cannot be an rvec.}

\item{n_draw}{Number of random draws
in the random vector being
created. Cannot be an rvec.}
}
\value{
\itemize{
\item If any of the arguments are rvecs,
or if a value for \code{n_draw} is supplied,
then an \link[=rvec]{rvec}; otherwise an ordinary R vector.
}
}
\description{
Density, distribution function,
quantile function and random generation for the
normal distribution, modified to work with
rvecs.
}
\details{
Functions \code{dnorm_rvec()}, \code{pnorm_rvec()},
\code{pnorm_rvec()} and \code{rnorm_rvec()} work like
base R functions \code{\link[=dnorm]{dnorm()}}, \code{\link[=pnorm]{pnorm()}},
\code{\link[=qnorm]{qnorm()}}, and \code{\link[=rnorm]{rnorm()}}, except that
they accept rvecs as inputs. If any
input is an rvec, then the output will be too.
Function \code{rnorm_rvec()} also returns an
rvec if a value for \code{n_draw} is supplied.

\code{dnorm_rvec()}, \code{pnorm_rvec()},
\code{pnorm_rvec()} and \code{rnorm_rvec()}
use \link[vctrs:theory-faq-recycling]{tidyverse}
vector recycling rules:
\itemize{
\item Vectors of length 1 are recycled
\item All other vectors must have the same size
}
}
\examples{
x <- rvec(list(c(3.1, -5.4),
               c(0.1, 2.3)))
dnorm_rvec(x)
pnorm_rvec(x)

rnorm_rvec(n = 2,
           mean = c(-3, 3),
           sd = c(2, 4),
           n_draw = 1000)
}
\seealso{
\itemize{
\item \code{\link[=dnorm]{dnorm()}}, \code{\link[=pnorm]{pnorm()}}, \code{\link[=qnorm]{qnorm()}}, \code{\link[=rnorm]{rnorm()}} Base R equivalents
\item \link[stats:Distributions]{distributions} All base R distributions
}
}
