% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws.R
\name{draws_median}
\alias{draws_median}
\alias{draws_median.rvec_chr}
\alias{draws_median.rvec}
\alias{draws_mean}
\alias{draws_mean.rvec}
\alias{draws_mean.rvec_chr}
\alias{draws_mode}
\alias{draws_mode.rvec}
\title{Medians, Means, and Modes Across Random Draws}
\usage{
draws_median(x, na_rm = FALSE)

\method{draws_median}{rvec_chr}(x, na_rm = FALSE)

\method{draws_median}{rvec}(x, na_rm = FALSE)

draws_mean(x, na_rm = FALSE)

\method{draws_mean}{rvec}(x, na_rm = FALSE)

\method{draws_mean}{rvec_chr}(x, na_rm = FALSE)

draws_mode(x, na_rm = FALSE)

\method{draws_mode}{rvec}(x, na_rm = FALSE)
}
\arguments{
\item{x}{An object of class \link[=rvec]{rvec}.}

\item{na_rm}{Whether to remove NAs before
calculating summaries. Default is \code{FALSE}.}
}
\value{
A vector.
}
\description{
Use means, medians, or modes to
summarise the distribution of random draws
in an rvec.
}
\details{
When \code{method} is \code{"mode"}, \code{reduce_rvec()}
returns the most common value for each
observation. When there is a tie, it returns
\code{NA}.
}
\examples{
m <- rbind(a = c(1, 1, 1, 2, 3),
           b = c(2, 4, 0, 2, 3),
           c = c(0, 0, 1, 0, 100))
x <- rvec(m)
x
draws_median(x)
draws_mean(x)
draws_mode(x)
}
\seealso{
Apply pre-specified functions across draws:
\itemize{
\item \code{\link[=draws_all]{draws_all()}}
\item \code{\link[=draws_any]{draws_any()}}
\item \code{\link[=draws_min]{draws_min()}}
\item \code{\link[=draws_max]{draws_max()}}
\item \code{\link[=draws_sd]{draws_sd()}}
\item \code{\link[=draws_var]{draws_var()}}
\item \code{\link[=draws_cv]{draws_cv()}}
\item \code{\link[=draws_ci]{draws_ci()}}
\item \code{\link[=draws_quantile]{draws_quantile()}}
}

Apply arbitrary function across draws:
\itemize{
\item \code{\link[=draws_fun]{draws_fun()}}
}
}
