% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyDESeq.R
\name{polyDESeq}
\alias{polyDESeq}
\title{Differential expression analysis}
\usage{
polyDESeq(P1_count, P2_count, F1_count, count_threshold = 5, Pvalue = 0.05)
}
\arguments{
\item{P1_count}{A dataframe. The count data of miRNA from the P1 species. The first column must be the miRNA sequence. Others are listed as the count of miRNA, and each column denotes one biological replicate of the sample.}

\item{P2_count}{A dataframe. Similar with P1_count, the count data of miRNA from the P2 species.}

\item{F1_count}{A dataframe. Similar with P1_count, the count data of miRNA from the F1 species.}

\item{count_threshold}{A numeric. In all samples, there is at least one sample whose count value is more than or equal to count_threshold to be retained. By default, the count value more than or equal to 5 is retained.}

\item{Pvalue}{A numeric. The threshold of significance test among different groups. Default is 0.05.}
}
\value{
A dataframe. Differential expression analysis results of miRNA expressed in each two species (count >= count_threshold).
}
\description{
Differential expression analysis
}
