\name{cnv.call}
\alias{cnv.call}
\title{
CNV Calling from Sequencing Data
}
\description{
Assign SCNA state to each segment directly from joint segmentation or from 
the results after segments merging step.}
\usage{
cnv.call(data, sample.id, segs.stat, maxL = NULL, N = 1000, 
         pvalue.cutoff = 0.05, seed = NULL,
         do.manual.baseline=FALSE,
         log2mBAF.left=NULL, log2mBAF.right=NULL, 
         log2ratio.bottom=NULL, log2ratio.up=NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{a data frame containing log2ratio and log2mBAF data generated 
  	by \code{\link{cnv.data}}.
}
  \item{sample.id}{sample ID to be displayed.
}
  \item{segs.stat}{a data frame containing segment locations and summary statistics 
  	resulting from \code{\link{joint.segmentation}} or \code{\link{merging.segments}}.
}
  \item{maxL}{integer. The maximum length in terms of number of probes a bootstrapped segment
  	may span. Default is \code{NULL}. If \code{NULL}, It will be automatically specified 
  	as 1/100 of the number of data points.
}
  \item{N}{the number of replicates drawn by bootstrap.
}
  \item{pvalue.cutoff}{a p-value cut-off for CNV calling.
}
  \item{seed}{integer. Random seed can be set for reproducibility of results.
}
  \item{do.manual.baseline}{logical. If baseline adjustment to be done manually. Default is \code{FALSE}.
}
  \item{log2mBAF.left, log2mBAF.right, log2ratio.bottom, log2ratio.up}{
  	left, right, bottom and up boundaries to be specified manually by a visual inspectio of 
  	2-D diagnosis plot generated by \code{\link{diagnosis.cluster.plot}}. 
  	These parameters are active when \code{do.manual.baseline=TRUE}.
}
}
\details{
The baseline adjustment step is incorporated implicitly in the function.
}
\value{
A few more columns have been add to the data frame resulting from 
\code{\link{joint.segmentation}} or \code{\link{merging.segments}}, 
which summarize the baseline adjusted median log2ratio, log2mBAF, 
p-values and CNV state for each segment.
}
%% \references{
%% ~put references to the literature/web site here ~
%% }
\author{
Zhongyang Zhang <zhongyang.zhang@mssm.edu>
}
%% \note{
%%  ~~further notes~~
%% }

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{joint.segmentation}}, \code{\link{merging.segments}}, \code{\link{cnv.data}}
}
\examples{
data(seq.data)
data(seq.segs.merge)

\dontrun{
seq.cnv <- cnv.call(data=seq.data, sample.id="PT116", 
                    segs.stat=seq.segs.merge, maxL=2000, N=1000,
                    pvalue.cutoff=0.05)
}

## how the results look like
data(seq.cnv)
head(seq.cnv)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ CNV }
\keyword{ CNV call }
