% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eblupBest.R
\name{eblupBest}
\alias{eblupBest}
\title{Selecting Auxiliary Variables in Small Area Estimation (SAE) Model}
\usage{
eblupBest(y, x, vardir, criterion = "AIC", data)
}
\arguments{
\item{y}{name of response variable}

\item{x}{vector of auxiliary variables' name}

\item{vardir}{name of variance direct}

\item{criterion}{"loglike","AIC", "BIC", and "KIC" (default = "AIC")}

\item{data}{input dataset}
}
\value{
an EBLUP-FH model with best auxiliary variables and the dataset
}
\description{
Select best combination of auxiliary variables with certain criterion
}
\examples{
library(saeBest)
example = eblupBest(y = "y", x = c("x1","x2","x3"), vardir = "var",data = data)

}
