% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.saehb}
\alias{summary.saehb}
\title{Summary sae HB model}
\usage{
\method{summary}{saehb}(object, ...)
}
\arguments{
\item{object}{sae HB model}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The function return a \code{data.frame} of beta coefficient from HB model.
}
\description{
Summary sae HB model
}
\examples{
library(dplyr)

Xarea <- cornsoybeanmeans \%>\%
   dplyr::select(
      County = CountyIndex,
      CornPix = MeanCornPixPerSeg,
      SoyBeansPix = MeanSoyBeansPixPerSeg
   )

corn_model <- hb_unit(
   CornHec ~ SoyBeansPix + CornPix,
   data_unit = cornsoybean,
   data_area = Xarea,
   domain = "County",
   iter.update = 20
)

summary(corn_model)

}
