% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixedPoint.R
\name{fixedPoint}
\alias{fixedPoint}
\alias{addAverageDamp}
\alias{addConstraintMin}
\alias{addConstraintMax}
\alias{convCritAbsolute}
\alias{convCritRelative}
\alias{addMaxIter}
\alias{addCounter}
\alias{addHistory}
\alias{addStorage}
\alias{newtonRaphson}
\alias{newtonRaphsonFunction}
\title{Fixed Point Algorithm Infrastructure}
\usage{
fixedPoint(fun, x0, convCrit)

addAverageDamp(fun)

addConstraintMin(fun, value)

addConstraintMax(fun, value)

convCritAbsolute(tolerance = 1e-06)

convCritRelative(tolerance = 1e-06)

addMaxIter(fun, maxIter)

addCounter(fun)

addHistory(fun)

addStorage(fun)

newtonRaphson(funList, ...)

newtonRaphsonFunction(funList)
}
\arguments{
\item{fun}{the function to be evaluated in the algorithm}

\item{x0}{starting value}

\item{convCrit}{a function returning a logical scalar. Is called with two
arguments; the first is the value from iteration n; the second is the value
from iteration n-1}

\item{value}{(numeric)}

\item{tolerance}{a numeric value > 0}

\item{maxIter}{maximum number of iterations}

\item{funList}{(list) the functions to be evaluated in the algorithm. First
element is typically the score function, second is the derivative of the
score.}

\item{...}{arguments passed to \code{\link{fixedPoint}}}
}
\description{
A fixed-point function supplied by the user is iteratively
  evaluated. \code{addAverageDamp} can be used to add average damping to the
  function - this may have a positive effect on the speed of convergence.
}
\details{
\code{addAverageDamp} adds average damping to an arbitrary fixed point
  function.

\code{addConstraintMin} takes care that values are not below a
  minimum value.

\code{addConstraintMax} takes care that values are not larger than
  maximum value.

\code{convCritAbsolute} absolute difference as convergence criterion.

\code{convCritRelative} relative (to previous iteration) absolute
  difference as convergence criterion. If value is smaller than 1, absolute
  difference is used.

\code{addMaxIter} can be used to modify convergence criterion functions.

\code{addCounter} can be used to count the number of calls of a function.

\code{addHistory} can be used to save a history of results of a
  function. The history is stored as a matrix, so this works best if the
  return value of \code{fun} is numeric.

\code{addStorage} will add a storage to a function. The storage is a
  list in which each result is stored. The function will coerce the return
  value into a numeric.

\code{newtonRaphson} finds zeroes of a function. The user can supply
  the function and its first derivative. Note that the Newton Raphson
  Algorithm is a special case of a fixed point algorithm thus it is
  implemented using \code{\link{fixedPoint}} and is only a convenience.
}
\examples{
\dontrun{
vignette("fixedPoint", "saeRobust")
}
}
