% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EBnaive.R
\name{EBnaive}
\alias{EBnaive}
\title{Small Area Estimation method with Empirical Bayes and its RRMSE value by Naive Method}
\usage{
EBnaive(data, method, opt, maxiter = 100, tol = 1e-05)
}
\arguments{
\item{data}{the data must contain two or three columns : code, y, and weight data if exist.}

\item{method}{Method to estimate alpha and beta parameter according to person(rao or claire)}

\item{opt}{Method to estimate alpha and beta parameter according to the way of calculation (moment or nr)}

\item{maxiter}{the Maximum iteration value with default 100}

\item{tol}{Tolerance error value at iteration with default 0.00001}
}
\value{
This function returns a list with following objects :
\item{finalres}{an information about direct estimatior and EB estimator in each area}
\item{estimation}{an information about EB estimator and its RRMSE value obtained by Naive method}
\item{parameter}{Alpha and beta estimator}
\item{pcap}{pcap (the weighted sample mean), vardir (the weighted sample variance),yt (the total number of the "success" category from each area), and nt (the total number of sample from each area)}
\item{dir.est}{an information about direct estimator}
}
\description{
Small Area Estimation method with Empirical Bayes and its RRMSE value by Naive Method
}
\examples{
## load dataset with no weight value
data(dataEB)
## Calculates EB estimator
## with its RRMSE value by Naive method.
## Its alpha and beta estimator obtained
## by Moment method by J.N.K.Rao
EBnaive(data = dataEB[,-c(3)],method = "rao",opt = "moment", maxiter = 100, tol = 1e-5)

##load dataset with weight value
data(dataEB)
## Calculates EB estimator
## with its RRMSE value by Naive method.
## Its alpha and beta estimator obtained
## by Moment method by Claire E.B.O.
EBnaive(data = dataEB, method = "claire",opt = "moment", maxiter = 100, tol = 1e-5)

}
