% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estEBnaive.R
\name{estEBnaive}
\alias{estEBnaive}
\title{Small Area Estimation method with Empirical Bayes and its RRMSE value by Naive Method}
\usage{
estEBnaive(data.dir, pcap, param)
}
\arguments{
\item{data.dir}{direct estimator information from function direct.est}

\item{pcap}{pcap (the weighted sample mean), vardir (the weighted sample variance),yt (the total number of the "success" category from each area), and nt (the total number of sample from each area)}

\item{param}{Alpha and Beta estimator}
}
\value{
This function returns a list with following objects :
\item{eb.est}{EB estimator in each area}
\item{mse}{MSE of EB estimator obtained by Naive method}
\item{rrmse}{RRMSE of EB estimator obtained by Naive method}
}
\description{
Small Area Estimation method with Empirical Bayes and its RRMSE value by Naive Method
}
\examples{
## load dataset with no weight value
data(dataEB)
temp = pcapdir(dataEB[,-c(3)])

## estimates alpha and beta parameter
## in EB estimate with Moment method by J.N.K.Rao
temp1 = alphabetaEB(data.dir = temp$direst ,pcap = temp$pcap,
                      method = "rao", opt = "moment",
                      maxiter = 100,tol = 0.00001)

## calculates EB estimator
## and its MSE by naive method
estEBnaive(data.dir = temp$direst, pcap = temp$pcap, param = temp1)

}
