% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sahpmlm.R
\name{sahpmlm}
\alias{sahpmlm}
\title{This implements the stochastic search based on Simulated Anneling strategy.}
\usage{
sahpmlm(formula, data, na.action, g = n, nstep = 200, abstol = 1e-07,
  replace = FALSE, burnin = FALSE, nburnin = 50)
}
\arguments{
\item{formula}{an object of class \code{\link{formula}} (or one that can be
coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible
by \code{\link{as.data.frame}} to a data frame) containing the variables in the
model. If not found in data, the variables are taken from environment(formula),
typically the environment from which \code{\link{lm}} is called.}

\item{na.action}{a function which indicates what should happen when the data contain
\code{NA}s.  The default is set by the \code{na.action} setting of
\code{\link{options}}, and is \code{\link{na.fail}} if that is unset.
The \dQuote{factory-fresh} default is \code{\link{na.omit}}.  Another possible
value is \code{NULL}, no action.  Value \code{\link{na.exclude}} can be useful.}

\item{g}{value of \eqn{g} for \eqn{g} prior. Default is sample size \eqn{n}.}

\item{nstep}{maximum number of steps for simulated annealing search.}

\item{abstol}{desired level of difference of marginal likelihoods between two steps.}

\item{replace}{logical. If \code{TRUE} the replce step is considered in the search. Default is FALSE.}

\item{burnin}{logical. If \code{TRUE} the burnin is added. Default is FALSE. Number of burnin is specified by the next input.}

\item{nburnin}{Number of burnin (required if burnin = TRUE). Default is 50.}
}
\value{
\item{final.model}{A column vector which corresponds to the original
variable indices.}
\item{history}{A history of the search process. By columns: Step number,
temperature, current objective function value, current minimal objective
function value, current model, posterior probability of current model.}
}
\description{
Highest posterior model is widely accepted as a good model among available
models. In terms of variable selection highest posterior model is often the true
model. Our stochastic search process SAHPM based on simulated annealing maximization method
tries to find the highest posterior model by maximizing the model space with
respect to the posterior probabilities of the models. This function currently
contains the SAHPM method only for linear models. The codes for GLM will be
added in future.
}
\details{
The model is:
\deqn{y= \alpha + X\beta+\epsilon, \epsilon \sim N(0,\sigma^2)}
The Zellner's \eqn{g} prior is used with default \eqn{g = n}.
}
\examples{
require(mvtnorm)     # for multivariate normal distribution
n <- 100             # sample size
k <- 40              # number of variables
z <- as.vector(rmvnorm(1, mean = rep(0, n), sigma = diag(n)))
x <- matrix(NA, nrow = n, ncol = k)
for(i in 1:k)
{
x[, i] <- as.vector(rmvnorm(1, mean = rep(0, n), sigma = diag(n))) + z
}                    # this induce 0.5 correlation among the variables
beta <- c(rep(0, 10), rep(2, 10), rep(0, 10), rep(2, 10))
                     # vector of coefficients
sigma <- 1
sigma.square <- sigma^2
linear.pred <- x \%*\% beta
y <- as.numeric(t(rmvnorm(1, mean = linear.pred, sigma = diag(sigma.square, n))))
                     # response
answer <- sahpmlm(formula = y ~ x)
answer$final.model
answer$history


\dontrun{
# With small effect size
beta <- c(rep(0, 10), rep(1, 10), rep(0, 10), rep(1, 10))
                     # vector of coefficients

linear.pred <- x \%*\% beta
y <- as.numeric(t(rmvnorm(1, mean = linear.pred, sigma = diag(sigma.square, n))))
                     # response
answer <- sahpmlm(formula = y ~ x)
answer$final.model  # Might miss some of the true predictors
answer$history

# Able to recover all the predictors with 50 burnin
answer <- sahpmlm(formula = y ~ x, burnin = TRUE, nburnin = 50)
answer$final.model  # Misses some of the true predictors
answer$history
}
}
\references{
Maity, A., K., and Basu, S. Highest Posterior Model Computation and
Variable Selection via the Simulated Annealing
}
