% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PowerSWD.R
\name{calcPower.SWD}
\alias{calcPower.SWD}
\title{Power calculation within stepped wedge design model by Hussey et.al or Heo&Kim}
\usage{
calcPower.SWD(ThetaEst, alpha = 0.05, Design, sigmaq, tauq,
  sigmaq.error = NULL, noSub = NULL, time = TRUE,
  type = "cross-sectional")
}
\arguments{
\item{ThetaEst}{expected treatment effect}

\item{alpha}{singificance level (by default 0.05)}

\item{Design}{design matrix for a given SWD model}

\item{sigmaq}{within cluster variance(between subject variance)}

\item{tauq}{between cluster variance}

\item{sigmaq.error}{within subject variance/error variance}

\item{noSub}{number of subjects within each cluster and each timepoint (for all an equal size)}

\item{time}{a logical (FALSE, if no time trends are expected, otherwise TRUE) is only relevant for evaluation of cross-sectional data}

\item{type}{is of cross-sectional (by default)  or longitudinal assigns the type of data (2 or 3 level nested structure)}
}
\value{
Aproximated power of two tailed test, although the design matrix is fractionated, then power is not valid
formula used for cross-sectional data provided by Michael A. Hussey and James P. Hughes,
Design and analysis of stepped wedge cluster randomized trials, 
Contemporary Clinical Trials(28),2007, 
and for longitudinal data by Heo M., Kim N., Rinke ML., Wylie-Rosett J., 
Sample size determinations for stepped-wedge clinical trials from a three-level data hierarchy perspective, 
Stat Methods Med Res., 2016
}
\description{
Calculation of power for a lmm with cluster as random effect, fixed timepoint effects, but set to null, TP number of timepoints, I number of cluster. The design matrix has to be coded by zeros and ones.
}
\examples{
noCl<-10
noT<-6
switches<-2
DM<-designMatrix(noCl,noT,switches)
sigma.e <- 2
sigma.alpha <- 2   
#Power for cross-sectional SWD design by formula of Hussey&Hughes 
calcPower.SWD(ThetaEst=1,Design=DM, sigmaq=sigma.e^2, tauq=sigma.alpha^2, time=FALSE)
calcPower.SWD(ThetaEst=1,Design=DM, sigmaq=sigma.e^2, tauq=sigma.alpha^2, time=TRUE)
#Power for longitudinal SWD design by formula of Heo&Kim 
DM.new<-NULL
for(i in 1:dim(DM)[2]){
DM.new<-cbind(DM.new,DM[,i], DM[,i])
}
s.e <- sqrt(7/10)
s <- sqrt(2/10)
s.a <- sqrt(1/10 )
K<- 10 #number of participants within each 'cell'
calcPower.SWD(ThetaEst=1, Design=DM.new, s.a^2, s^2, s.e^2,  noSub=K,  type="longitudinal")
}

