% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designMatrix.R
\name{designMatrix}
\alias{designMatrix}
\title{Design matrix for SWD model}
\usage{
designMatrix(nC, nT, nSw, swP = NULL, design = "SWD")
}
\arguments{
\item{nC}{number of cluster}

\item{nT}{number of timepoints}

\item{nSw}{number of cluster : within parallel recieve the control (nC-nSw receive the intervention), within cross-over recieve the pattern (0, 1) (nC-nSw receive the pattern (1,0)) for nearly the same number of time points, within SWD switches from control to intervention per time point}

\item{swP}{is the time point the cluster cross over the condition in a cross over study, if not given then it is nearly half of the time past}

\item{design}{is the study type (parallel, cross-sectional, stepped wedge)}
}
\value{
design matrix for a given setup of a stepped wedge design
}
\description{
create design matrix for a given setup of a stepped wedge design
}
\examples{

designMatrix(5,6,1)

K<-6  #measurement (or timepoints)
I<-10 #Cluster
designMatrix(nC=I, nT=K, nSw=2)

}

