% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_functions.R
\name{calc_autocorr}
\alias{calc_autocorr}
\title{Autocorrelation Calculator}
\usage{
calc_autocorr(chain, change = TRUE, alpha = 0.05, lag.max = 100, plot = FALSE)
}
\arguments{
\item{chain}{Vector of n length, where n is the number of trials or sampler iterations}

\item{change}{Boolean. If true, plot the autocorrelation of the change series. If false, plot the autocorrelation of the given chain.}

\item{alpha}{Measure of Type I error - defaults to .05}

\item{lag.max}{Length of the x axis. How far to examine the lags.}

\item{plot}{Boolean. Whether to additionally plot the result.}
}
\value{
A vector with the standard deviations at each lag
}
\description{
Calculates the autocorrelation of a given sequence, or of the size of the steps (returns).
}
\details{
Markets display no significant autocorrelations in the returns of a given asset.
}
\examples{
set.seed(1)
chain1 <- sampler_mh(1, "norm", c(0,1), diag(1))
calc_autocorr(chain1[[1]], plot=TRUE)
}
