% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{sampler_mcrec}
\alias{sampler_mcrec}
\title{Metropolis-Coupled Recycled-Momentum HMC Sampler (MCREC)}
\usage{
sampler_mcrec(
  start,
  distr_name = NULL,
  distr_params = NULL,
  epsilon = 0.5,
  L = 10,
  alpha = 0.1,
  nChains = 6,
  delta_T = 4,
  swap_all = TRUE,
  iterations = 1024L,
  weights = NULL,
  custom_density = NULL
)
}
\arguments{
\item{start}{Vector. Starting position of the sampler.}

\item{distr_name}{Name of the distribution from which to sample from.}

\item{distr_params}{Distribution parameters.}

\item{epsilon}{Size of the leapfrog step}

\item{L}{Number of leapfrog steps per iteration}

\item{alpha}{Recycling factor, from -1 to 1 (see Details).}

\item{nChains}{Number of chains to run.}

\item{delta_T}{numeric, >1. Temperature increment parameter. The bigger this number, the steeper the increase in temperature between the cold chain and the next chain}

\item{swap_all}{Boolean. If true, every iteration attempts floor(nChains / 2) swaps. If false, only one swap per iteration.}

\item{iterations}{Number of iterations of the sampler.}

\item{weights}{If using a mixture distribution, the weights given to each constituent distribution. If none given, it defaults to equal weights for all distributions.}

\item{custom_density}{Instead of providing names, params and weights, the user may prefer to provide a custom density function.}
}
\value{
A named list containing
\enumerate{
\item{Samples: the history of visited places (an n x d x c array, n = iterations; d = dimensions; c = chain index, with c==1 being the 'cold chain')}
\item{Momentums: the history of momentum values (an n x d x c array, n = iterations; d = dimensions; c = chain index, with c==1 being the 'cold chain'). Nothing is proposed in the first iteration (the first iteration is the start value) and so the first row is NA}
\item{Acceptance Ratio: The proportion of proposals that were accepted (for each chain).}
\item{Beta Values: The set of temperatures used in each chain}
\item{Swap History: the history of chain swaps}
\item{Swap Acceptance Ratio: The ratio of swap acceptances}
}
}
\description{
Metropolis-Coupled version of Recycled-Momentum HMC, i.e. running multiple chains at different temperatures which stochastically swap positions.
}
\details{
Metropolis-Coupled Recycled-Momentum HMC does not support discrete distributions.

This algorithm has been used to model human data in \insertCite{castillo2024ExplainingFlawsHuman;textual}{samplr}.
}
\examples{

result <- sampler_mcrec(
    distr_name = "norm", distr_params = c(0,1), 
    start = 1, epsilon = .01, L = 100
)
cold_chain <- result$Samples[,,1]
}
\references{
\insertAllCited{}
}
