% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svd.R
\name{svd2}
\alias{svd2}
\title{Singular Value Decomposition}
\usage{
svd2(a, type = c("BDC", "Jacobi"), vectors = TRUE, thin = TRUE)
}
\arguments{
\item{a}{Numeric matrix.}

\item{type}{Character scalar. Whether to use BDC or Jacobi SVD.}

\item{vectors}{Logical scalar indicating whether singular vectors should be
computed and returned.}

\item{thin}{Logical scalar indicating whether singular vectors should be
returned in thinned or full format.}
}
\value{
Solves the generalised eigenproblem and returns a list with
singular values in the \code{"d"} component and, if requested, singular
vectors in the components \code{"u"} and \code{"v"}.
}
\description{
Solvers for generalized eigenproblems around the matrix \eqn{A}. Compute
singular values \eqn{\Sigma}{s}, left singular vectors \eqn{U}{U} and
right singular vectors \eqn{V}{V} of \eqn{A}{A}, such that
\eqn{A = U \Sigma V^*}{A = USV^*}. Two different types are available: (1)
bidiagonal divide and conquer strategy (BDC) SVD, and (2) two-sided Jacobi
SVD for small matrices (<16) and high accuracy.
}
\examples{
set.seed(42)
# Compute singular values and vectors using BDC
A <- matrix(rnorm(9), nrow = 3, ncol = 3)
sv <- svd2(A)

# Compute singular values using Jacobi
A <- matrix(rnorm(9), nrow = 3, ncol = 3)
sv <- svd2(A, type = "J", vectors = FALSE)

# Compute singular values and full vectors using BDC
A <- matrix(rnorm(12), nrow = 4, ncol = 3)
sv <- svd2(A, type = "B", thin = FALSE)
A <- matrix(rnorm(12), nrow = 3, ncol = 4)
sv <- svd2(A, type = "B", thin = FALSE)

}
