% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{lbl_dash}
\alias{lbl_dash}
\title{Label chopped intervals like 1-4, 4-5, ...}
\usage{
lbl_dash(
  symbol = em_dash(),
  fmt = NULL,
  single = "{l}",
  first = NULL,
  last = NULL,
  raw = FALSE
)
}
\arguments{
\item{symbol}{String: symbol to use for the dash.}

\item{fmt}{String, list or function. A format for break endpoints.}

\item{single}{Glue string: label for singleton intervals. See \code{\link[=lbl_glue]{lbl_glue()}}
for details. If \code{NULL}, singleton intervals will be labelled the same way
as other intervals.}

\item{first}{Glue string: override label for the first category. Write e.g.
\code{first = "<{r}"} to create a label like \code{"<18"}. See \code{\link[=lbl_glue]{lbl_glue()}}
for details.}

\item{last}{String: override label for the last category. Write e.g.
\code{last = ">{l}"} to create a label like \code{">65"}. See \code{\link[=lbl_glue]{lbl_glue()}}
for details.}

\item{raw}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}. Use the \code{raw} argument to \code{\link[=chop]{chop()}}
instead.}
}
\value{
A function that creates a vector of labels.
}
\description{
This label style is user-friendly, but doesn't distinguish between
left- and right-closed intervals. It's good for continuous data
where you don't expect points to be exactly on the breaks.
}
\details{
If you don't want unicode output, use \code{lbl_dash("-")}.
}
\section{Formatting endpoints}{


If \code{fmt} is not \code{NULL} then it is used to format the endpoints.
\itemize{
\item If \code{fmt} is a string, then numeric endpoints will be formatted by
\code{sprintf(fmt, breaks)}; other endpoints, e.g. \link{Date} objects, will be
formatted by \code{format(breaks, fmt)}.
\item If \code{fmt} is a list, then it will be used as arguments to \link{format}.
\item If \code{fmt} is a function, it should take a vector of numbers (or other objects
that can be used as breaks) and return a character vector. It may be helpful
to use functions from the \code{{scales}} package, e.g. \code{\link[scales:label_number]{scales::label_comma()}}.
}
}

\examples{
chop(1:10, c(2, 5, 8), lbl_dash())

chop(1:10, c(2, 5, 8), lbl_dash(" to ", fmt = "\%.1f"))

chop(1:10, c(2, 5, 8), lbl_dash(first = "<{r}"))

pretty <- function (x) prettyNum(x, big.mark = ",", digits = 1)
chop(runif(10) * 10000, c(3000, 7000), lbl_dash(" to ", fmt = pretty))
}
\seealso{
Other labelling functions: 
\code{\link{lbl_discrete}()},
\code{\link{lbl_endpoints}()},
\code{\link{lbl_glue}()},
\code{\link{lbl_intervals}()},
\code{\link{lbl_manual}()},
\code{\link{lbl_midpoints}()},
\code{\link{lbl_seq}()}
}
\concept{labelling functions}
