% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snowprofile.R
\name{reformat_snowprofile}
\alias{reformat_snowprofile}
\title{Reformat a malformatted snowprofile object}
\usage{
reformat_snowprofile(profile, currentFields = NULL, targetFields = NULL)
}
\arguments{
\item{profile}{\link{snowprofile} object}

\item{currentFields}{array of character strings specifying the current field names that you want to change}

\item{targetFields}{array of same size than \code{currentFields} specifying the new field names}
}
\description{
Reformat a malformatted snowprofile object. A malformatted object may use field names that deviate from our
suggested field names (e.g., \code{grain_type} instead of \code{gtype}), or it may use data types that are different than
what we suggest to use (e.g., \code{ddate} as type \code{Date} instead of \code{POSIXct}). Basically, if your snowprofile object
fails the test of \link{validate_snowprofile} due to the above reason this function should fix it.
}
\examples{

## check the malformatted profile:
this_throws_error <- TRUE
if (!this_throws_error) {
validate_snowprofile(SPmalformatted[[1]])
}
## i.e., we see that elev and ddate are of wrong data type,
## and a warning that grain_type is an unknown layer property.

## reformat field types, but not the field name:
betterProfile <- reformat_snowprofile(SPmalformatted[[1]])
## i.e., no error is raised anymore, but only the grain_type warning

## so let's reformat also the field names:
optimalProfile <- reformat_snowprofile(SPmalformatted[[1]], "grain_type", "gtype")



## reformat a list of profiles with the same configuration:
SPmalformatted_reformatted <- lapply(SPmalformatted, reformat_snowprofile,
                                     currentFields = "grain_type", targetFields = "gtype")

## the malformatted profile set finally is correctly formatted:
lapply(SPmalformatted_reformatted, validate_snowprofile)


}
