% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snowprofileCsv_advanced.R
\name{snowprofileCsv_advanced}
\alias{snowprofileCsv_advanced}
\title{Read routine for advanced csv tables containing various snowprofile information}
\usage{
snowprofileCsv_advanced(
  csvFile,
  meta = c("uid", "hs", "maxObservedDepth", "comment"),
  layers = c("depth", "height", "gtype", "hardness", "datetag", "gsize", "gtype_sec",
    "layer_comment"),
  tests = c("test", "result", "fract_char", "score", "test_depth", "test_comment"),
  instabilitySigns = c("instabilitySign_type", "instabilitySign_present",
    "instabilitySign_comment"),
  sep = ",",
  elev.units = "ft",
  tz = "UTC"
)
}
\arguments{
\item{csvFile}{'path/to/file.csv'}

\item{meta}{column names of block metadata}

\item{layers}{column names of block \link{snowprofileLayers}}

\item{tests}{column names of block \link{snowprofileTests}}

\item{instabilitySigns}{column names of block \link{snowprofileInstabilitySigns}}

\item{sep}{csv column separator}

\item{elev.units}{if set to "ft", the routine will convert to "m". Set to "m" (or anything else) if it should be unchanged}

\item{tz}{time zone (default = 'UTC')}
}
\description{
This routine reads blocks of snowprofile metadata, layers, tests, and stability signs. Columns contain different variables,
rows different observations. While metadata only contains one row, layers, tests, and signs consist of potentially multiple
rows. Within each block of information, mind the correct alignment of rows. Missing values (i.e., NA) need to be left blank
or called \code{NA}. See the examples below including the example file shipped with the package.
}
\examples{
## load example csv file that ships with package:
csvFile <- system.file('extdata', 'example_adv.csv', package = 'sarp.snowprofile')

profile <- snowprofileCsv_advanced(csvFile, meta = c("uid", "hs", "maxObservedDepth", "comment",
                                                     "datetime", "zone", "station",
                                                     "station_id", "aspect", "elev", "angle"))

plot(profile)

}
\author{
fherla
}
