% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpFilter.R
\name{SpFilter}
\alias{SpFilter}
\title{A function for filtering low expressed genes}
\usage{
SpFilter(ExpMat_Sp, Threshold = 5)
}
\arguments{
\item{ExpMat_Sp}{A sparse, N x M expression matrix in dgCMatrix class with N genes and M spots}

\item{Threshold}{A threshold set to filter out genes with a total read count below this specified value}
}
\value{
A sparse expression matrix in dgCMatrix class
}
\description{
A function for filtering low expressed genes
}
\examples{
# create a sparse expression matrix
Raw_ExpMat <- Matrix::rsparsematrix(nrow = 10000, ncol = 2000, 
density = 0.01, rand.x = function(n) rpois(n, 15))
Filtered_ExpMat <- SpFilter(Raw_ExpMat)
}
