% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReactomeGSAAnalysis.R
\name{ReactomeData}
\alias{ReactomeData}
\title{Reactome Data Analysis for Seurat Object}
\usage{
ReactomeData(lowdim_seurat_object)
}
\arguments{
\item{lowdim_seurat_object}{Seurat object that has clusters information}
}
\value{
A list containing:
- GSVA result (\code{gsva_result})
- Pathway expression data (\code{pathway_expression})
- Max difference between pathway expression values (\code{max_difference})
}
\description{
This function performs pathway analysis using ReactomeGSA on a Seurat object
with cluster information.
}
\examples{
\donttest{
library(Seurat)
# Read 10X counts data from matrix.mtx, barcodes.tsv and genes.tsv
counts <- Read10X(data.dir = "../inst/extdata", gene.column = 1)

# Create Seurat object without batch correction
seurat_obj <- SeuratPreprocess(counts)
seurat_obj <- SeuratLowDim(seurat_obj)
# Reactome Analysis
seurat_reactome <- ReactomeData(seurat_obj)
}
}
