#' @noRd

#MCMC
ScalableBayesmConstant.keep = 1             #keep every keepth draw for MCMC routines
ScalableBayesmConstant.nprint = 100         #print the remaining time on every nprint'th draw
ScalableBayesmConstant.RRScaling = 2.38     #Roberts and Rosenthal optimal scaling constant
ScalableBayesmConstant.w = .1               #fractional likelihood weighting parameter

#Priors
ScalableBayesmConstant.A = .01              #scaling factor for the prior precision matrix
ScalableBayesmConstant.nuInc = 3            #Increment for nu
ScalableBayesmConstant.a = 5                #Dirichlet parameter for mixture models
ScalableBayesmConstant.nu.e = 3.0           #degrees of freedom parameter for regression error variance prior
ScalableBayesmConstant.nu = 3.0             #degrees of freedom parameter for Inverted Wishart prior
ScalableBayesmConstant.agammaprior = .5     #Gamma prior parameter
ScalableBayesmConstant.bgammaprior = .1     #Gamma prior parameter

#DP
ScalableBayesmConstant.DPalimdef=c(.01,10)  #defines support of 'a' distribution
ScalableBayesmConstant.DPnulimdef=c(.01,3)  #defines support of nu distribution
ScalableBayesmConstant.DPvlimdef=c(.1,4)    #defines support of v distribution
ScalableBayesmConstant.DPIstarmin = 1       #expected number of components at lower bound of support of alpha
ScalableBayesmConstant.DPpower = .8         #power parameter for alpha prior
ScalableBayesmConstant.DPalpha = 1.0        #initialized value for alpha draws
ScalableBayesmConstant.DPmaxuniq = 200      #storage constraint on the number of unique components
ScalableBayesmConstant.DPSCALE = TRUE       #should data be scaled by mean,std deviation before posterior draws
ScalableBayesmConstant.DPgridsize = 20      #number of discrete points for hyperparameter priors

#Mathematical Constants
ScalableBayesmConstant.gamma = .5772156649015328606

#BayesBLP
ScalableBayesmConstant.BLPVOmega = matrix(c(1,0.5,0.5,1),2,2)  #IW prior parameter of correlated shocks in IV bayesBLP
ScalableBayesmConstant.BLPtol = 1e-6