% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterPlotMatrix.R
\name{setZAxis}
\alias{setZAxis}
\title{Z axis}
\usage{
setZAxis(id, dim)
}
\arguments{
\item{id}{Output variable to read from (id which references the requested plot).}

\item{dim}{name of the column to use as reference.}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Tells which column to use as reference to determine color of each points.
}
\examples{
 if(interactive() && require(shiny)) {
   library(shiny)
   library(scatterPlotMatrix)

   ui <- fluidPage(
     fluidRow(
       column(
         2,
         selectInput("zAxisSelect", "Z Axis:", colnames(iris))
       ),
       column(
         2,
         checkboxInput("zAxisUsedCB", "Use Z Axis", FALSE)
       )
     ),
     scatterPlotMatrixOutput("spMatrix")
   )

   server <- function(input, output, session) {
     output$spMatrix <- renderScatterPlotMatrix({
       scatterPlotMatrix(iris)
     })

     observe({
       scatterPlotMatrix::setZAxis(
         "spMatrix",
         if (input$zAxisUsedCB) input$zAxisSelect else NULL
       )
     })
   }

   shinyApp(ui, server)
 }

}
