% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{segment.pconductance}
\alias{segment.pconductance}
\title{Calculate empirical P(Lower <= Conductance <= Upper) of a segment.}
\usage{
segment.pconductance(segment, level)
}
\arguments{
\item{segment}{the segment object}

\item{level}{conductance level}
}
\value{
The probability of being in this conductance state
}
\description{
Calculate empirical P(Lower <= Conductance <= Upper) of a segment.
}
\examples{

# It's more likely that you created states or dwells with some function
states  <-  c(0,    0.2,    0,    1,    0,  0.5,    0,  0.7,    0,    1)
dwells  <-  c(0.1,  1.1,  0.5,  0.2,  1.0,  1.1,  0.6,  1.1,  0.8,  1.1)
my_burst <- segment.create(states, dwells, seg=1, start_time=3.14159, name="example_segment")

segment.pconductance(my_burst, 0.5)

}
