% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{segment.subconductance_as}
\alias{segment.subconductance_as}
\title{Imposes a fixed conductance level (0 or 1) to all dwells with subconductance levels.}
\usage{
segment.subconductance_as(segment, level)
}
\arguments{
\item{segment}{the segment containing dwells and states.}

\item{level}{either 'open' or 'closed'}
}
\value{
A modified copy of the original segment
}
\description{
The user specifies the desired level ('open' or 'closed'). The function will modify
any subconductance level (that is not 0 or 1) to be the desired level 1 for 'open'
or 0 for 'closed'. The function then reutrns a collapsed segment containing 
alternating dwells.
(See segment.consecutives_to_dwells for details about the collapsed segment.)
}
\examples{

# It's more likely that you created states or dwells with some function
states  <-  c(0,    0.2,    0,    1,    0,  0.5,    0,  0.7,    0,    1)
dwells  <-  c(0.1,  1.1,  0.5,  0.2,  1.0,  1.1,  0.6,  1.1,  0.8,  1.1)
my_burst <- segment.create(states, dwells, seg=1, start_time=3.14159, name="example_segment")

my_burst_d <- segment.subconductance_as(my_burst, "open")

}
