% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_gls_app.R
\name{replext_pgsql}
\alias{replext_pgsql}
\title{Replication and Extension of Generalized Least Squares Simulation Shiny App}
\usage{
replext_pgsql(dbname, datatable, host, port, user, password)
}
\arguments{
\item{dbname}{Character string. The name of the PostgreSQL database to connect to.}

\item{datatable}{Character string. The name of the table in the database where
results will be stored.}

\item{host}{Character string. The host name or IP address of the PostgreSQL server.}

\item{port}{Integer. The port number on which the PostgreSQL server is listening.}

\item{user}{Character string. The username for the PostgreSQL database connection.}

\item{password}{Character string. The password for the PostgreSQL database
connection.}
}
\value{
A Shiny app object which can be run to start the application.
}
\description{
This function creates a Shiny app for running and visualizing simulations of
Generalized Least Squares (GLS) models, extending the work of Maric et al. (2014).
It allows users to interactively set simulation parameters, run simulations,
view results, and generate plots.
}
\details{
The app provides a user interface for:
\itemize{
\item Setting simulation parameters
\item Running simulations based on the specified parameters
\item Viewing simulation results in a table format
\item Generating plots of various metrics across different conditions
\item Storing and retrieving results from a PostgreSQL database
\item Displaying relevant citations
}

The app uses the \code{replext_gls()} function to perform the actual simulations.
}
\examples{
if(interactive()){
replext_pgsql(
  dbname = "my_database",
  datatable = "simulation_results",
  host = "localhost",
  port = 5432,
  user = "myuser",
  password = "mypassword"
)
}

}
\references{
Maric, M., de Haan, E., Hogendoorn, S.M., Wolters, L.H. & Huizenga, H.M. (2014).
Evaluating statistical and clinical significance of intervention effects in
single-case experimental designs: An SPSS method to analyze univariate data.
Behavior Therapy. doi: 10.1016/j.beth.2014.09.009
}
\seealso{
\code{\link{replext_gls}} for the underlying simulation function.
}
