% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highly_cited.R
\name{highly_cited}
\alias{highly_cited}
\title{Highly Cited Instances}
\usage{
highly_cited(citations, pub_years, ref_citations = NULL,
  ref_pub_years = NULL, top = NULL, year_lim = list())
}
\arguments{
\item{citations}{A numeric vector containing citations}

\item{pub_years}{A numeric vector containing publication years}

\item{ref_citations}{The citations of reference instances}

\item{ref_pub_years}{The publication years of reference instances}

\item{top}{An integer which defines top percent highly cited instances}

\item{year_lim}{A list conating years and year-wise citation threshold. If not mentioned
these values are calculated from ref_citations, ref_pub_years & top.}
}
\value{
Returns a list containing number of top highly cited instances with other details
}
\description{
It finds the number of highly cited instances year-wise.
}
\examples{
citations<-c(2,0,12,3,1,1,4,5,8,2)
pub_years<-c(2011,2011,2012,2011,2013,2011,2011,2012,2011,2013)
ref_citations<-c(3,0,12,3,1,1,41,5,8,2,2,0,12,30,1,1,4,5,8,12)
ref_pub_years<-c(2012,2011,2012,2013,2013,2011,2011,2012,
2011,2013,2011,2011,2012,2011,2013,2011,2011,2012,2011,2013)
highly_cited(citations,pub_years,ref_citations,ref_pub_years,10)
highly_cited(citations,pub_years,year_lim = list(c(2011, 2012, 2013), c(41, 12, 12)))
}

