% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-correlations.R
\name{get_correlations}
\alias{get_correlations}
\title{Calculate correlation between metrics}
\usage{
get_correlations(scores, metrics = get_metrics.scores(scores), ...)
}
\arguments{
\item{scores}{An object of class \code{scores} (a data.table with
scores and an additional attribute \code{metrics} as produced by \code{\link[=score]{score()}}).}

\item{metrics}{A character vector with the metrics to show. If set to
\code{NULL} (default), all metrics present in \code{scores} will be shown.}

\item{...}{Additional arguments to pass down to \code{\link[=cor]{cor()}}.}
}
\value{
An object of class \code{scores} (a data.table with an additional
attribute \code{metrics} holding the names of the scores) with correlations
between different metrics
}
\description{
Calculate the correlation between different metrics for a data.frame of
scores as produced by \code{\link[=score]{score()}}.
}
\examples{
library(magrittr) # pipe operator

scores <- example_quantile \%>\%
 as_forecast_quantile() \%>\%
 score()

get_correlations(scores)
}
\keyword{scoring}
