% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{summary.scqe}
\alias{summary.scqe}
\alias{print.scqe}
\title{Summary method for \code{scqe}}
\usage{
\method{summary}{scqe}(object, ...)

\method{print}{scqe}(x, ...)
}
\arguments{
\item{object}{an object of class \code{\link{scqe}}}

\item{...}{Extra optional arguments}

\item{x}{an object of class \code{\link{scqe}}}
}
\value{
Text interpretations of your results from scqe method results table.

Results table.
}
\description{
The \code{summary} method provides several statements that summarize
important values of delta requires to make different conclusions
about the treatment's effect on patient outcome.

The \code{ptin} method provides the result table that
includes the given delta values and their conclusions
about the treatment's effect on patient outcome.
}
\examples{
set.seed(1234)
post <- c(rep(0, 100), rep(1, 100))
tx <- c(rep(0, 100), rbinom(n = 100, prob = 0.27, size = 1))
y <- rbinom(n = 200, prob = 0.1 + 0.02 * post - 0.05 * tx, size = 1)

# Two cohorts, full data
scqe.2cohort.full = scqe(post = post, treatment = tx, outcome = y,
                         delta=seq(from = -0.1, to = 0.1, by = 0.05))
summary(scqe.2cohort.full)

set.seed(1234)
post = c(rep(0,100), rep(1,100))
tx = c(rep(0, 100), rbinom(n = 100, prob = 0.27, size = 1))
y = rbinom(n= 200, prob = 0.1 + 0.02 * post - 0.05 * tx, size = 1)

# Two cohorts, full data
scqe.2cohort.full = scqe(post = post, treatment = tx, outcome = y,
                         delta = seq(from = -0.1, to = 0.1, by = 0.05))
scqe.2cohort.full
print(scqe.2cohort.full)

}
