% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{value_convert}
\alias{value_convert}
\alias{scribe_convert}
\title{Simple conversions}
\usage{
value_convert(x, to = default_convert)

scribe_convert(method = c("default", "evaluate", "none"))
}
\arguments{
\item{x}{A vector of character values}

\item{to}{What to convert \code{x} to (see details for more)}

\item{method}{The conversion method:
\itemize{
\item \code{TRUE} or \code{"default"}: uses \code{\link[=value_convert]{value_convert()}}
\item \code{"evaluate"} executes the string as an expression
\item \code{FALSE} or \code{NA} does nothing
\item When passed a \code{function}, simply returns the function
}}
}
\value{
\itemize{
\item \code{\link[=value_convert]{value_convert()}}: A parsed value from \code{x}
}

\itemize{
\item \code{\link[=scribe_convert]{scribe_convert()}}: A function that takes a argument \code{x} and converts it
}
}
\description{
Convert character to data types
}
\details{
\code{to} can be one of several values.  Firstly the default of \code{default}
calls several additional functions that attempt to resolve a transformation
from a \code{character} vector to a different type.  It is recommended for users
to enter their own specifications instead.  Secondly, a \code{function} (with a
single argument) can be passed which will then be applied directly to \code{x}.
Third, a \emph{prototype} value can be passed.  This might be risky for special
types.  Here, the values of \code{\link[=mode]{mode()}}, \code{\link[=storage.mode]{storage.mode()}}, \code{\link[=attributes]{attributes()}}, and
\code{\link[=class]{class()}} are captured and reassigned from \code{to} to \code{x}.  A special check is
implemented for \code{factor}s to more safely convert.  Lastly, \code{NULL} will do
nothing and will simply return \code{x}.
}
\examples{
str(value_convert("2023-03-05", as.Date))
value_convert("a", factor(letters))
}
