% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_sensitive_at.R
\name{is_sensitive_at}
\alias{is_sensitive_at}
\title{Calculate sensitivity from  a sdc_raster at x,y locations.}
\usage{
is_sensitive_at(x, xy, ...)
}
\arguments{
\item{x}{\code{\link[=sdc_raster]{sdc_raster()}}}

\item{xy}{matrix of x and y coordinates, or a SpatialPoints or
SpatialPointsDataFrame object}

\item{...}{
  Arguments passed on to \code{\link[=is_sensitive]{is_sensitive}}
  \describe{
    \item{\code{max_risk}}{a risk value higher than \code{max_risk} will be sensitive.}
    \item{\code{min_count}}{a count lower than \code{min_count} will be sensitive.}
    \item{\code{risk_type}}{what kind of measure should be used (see details).}
  }}
}
\value{
\code{logical} vector with
}
\description{
Calculate sensitivity from  a sdc_raster at x,y locations.
A typical use is to calculate the sensitivity for each of the locations \code{x}
was created with (see example).
}
\examples{
\donttest{
production <- sdc_raster(enterprises, "production")

# add the sensitive variable to original data set.
enterprises$sensitive <- is_sensitive_at(production, enterprises)
}
}
\seealso{
Other sensitive: 
\code{\link{disclosure_risk}()},
\code{\link{is_sensitive}()},
\code{\link{plot_sensitive}()},
\code{\link{remove_sensitive}()},
\code{\link{sdc_raster}()},
\code{\link{sensitivity_score}()}
}
\concept{sensitive}
