% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_aerel.R
\name{check_ae_aerel}
\alias{check_ae_aerel}
\title{Check for AEREL1 - AERELN when AEREL is missing and when AEREL is unexpected}
\usage{
check_ae_aerel(AE, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with variables USUBJID, AESEQ, AETERM,
AESTDTC, AEREL, AERELn, AESPID (if present)}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
Flag if patient has a record with null value of AEREL
but AEREL1 - AERELN contain 'Y'/'N'/'NA', so a likely mapping issue
or if AEREL is missing and there is no any AERELn variable
or if AEREL has unexpected value
}
\examples{

AE <- data.frame(
    STUDYID = 1001,
    USUBJID = c(1,2,3,1,2,3),
    AESTDTC = rep('2020-05-05',6),
    AETERM  = c("abc Covid-19", "covid TEST POSITIVE","CHILLS"),
    AESEQ   = c(1,1,1,2,2,2),
    AEREL   = c("Y", "N", "NA", "N", "N", "Y"),
    AEREL1  = c("Y", "N", "NA", "N", "NA", "Y"),
    AEREL2  = c("Y", "N", "NA", "N", "N", "N"),
    AESPID = "FORMNAME-R:13/L:13XXXX",
    stringsAsFactors = FALSE
)

check_ae_aerel(AE)

AE1 <- data.frame(
    STUDYID = 1001,
    USUBJID = c(1,2,3,1,2,3),
    AESTDTC = rep('2020-05-05',6),
    AETERM  = c("abc Covid-19", "covid TEST POSITIVE","CHILLS"),
    AESEQ   = c(1,1,1,2,2,2),
    AEREL   = c("Y", "N", "N", "N", "N", "N"),
    AEREL1  = c("Y", "N", "NA", "N", "N", ""),
    AEREL2  = c("Y", "N", " ", "N", "N", " "),
    AESPID = "FORMNAME-R:13/L:13XXXX",
    stringsAsFactors = FALSE
)

check_ae_aerel(AE1)
check_ae_aerel(AE1,preproc=roche_derive_rave_row)

AE2 <- data.frame(
    STUDYID = 1001,
    USUBJID = c(1,2,3,1,2,3),
    AESTDTC = rep('2020-05-05',6),
    AETERM  = c("abc Covid-19", "covid TEST POSITIVE","CHILLS"),
    AESEQ   = c(1,1,1,2,2,2),
    AEREL   = c("Y", "N", " ", "N", "N", " "),
    AEREL1  = c("NA", "N", "NA", "Y", "N", " "),
    AEREL2  = c("Y", "N", " ", "N", "N", " "),
    AESPID = "FORMNAME-R:13/L:13XXXX",
    stringsAsFactors = FALSE
)

check_ae_aerel(AE2)
check_ae_aerel(AE2,preproc=roche_derive_rave_row)

AE3 <- data.frame(
    STUDYID = 1001,
    USUBJID = c(1,2,3,1,2,3),
    AESTDTC = rep('2020-05-05',6),
    AETERM  = c("abc Covid-19", "covid TEST POSITIVE","CHILLS"),
    AESEQ   = c(1,1,1,2,2,2),
    AEREL   = c("Y", " ", " ", "N", " ", "NA"),
    AESPID = "FORMNAME-R:13/L:13XXXX",
    stringsAsFactors = FALSE
)

check_ae_aerel(AE3)
check_ae_aerel(AE3,preproc=roche_derive_rave_row)


AE4 <- data.frame(
    STUDYID = 1001,
    USUBJID = c(1,2,3,4,5,6),
    AESTDTC = rep('2020-05-05',6),
    AETERM  = c("abc Covid-19", "covid TEST POSITIVE","CHILLS"),
    AESEQ   = c(1,2,3,4,5,6),
    AEREL   = c("Y", "Y", "N", "", "Y", "NA"),
    AEREL1  = "",
    AEREL2  = "",
    AESPID = "FORMNAME-R:13/L:13XXXX",
    stringsAsFactors = FALSE
)

check_ae_aerel(AE4)
check_ae_aerel(AE4,preproc=roche_derive_rave_row)

}
\author{
Vira Vrakina
}
