% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_dd_ae_aedthdtc_ds_dsstdtc.R
\name{check_dd_ae_aedthdtc_ds_dsstdtc}
\alias{check_dd_ae_aedthdtc_ds_dsstdtc}
\title{Check if death date is the same in AE and DS domains}
\usage{
check_dd_ae_aedthdtc_ds_dsstdtc(AE, DS, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with variables USUBJID and AEDTHDTC}

\item{DS}{Disposition SDTM dataset with variables USUBJID, DSDECOD, DSSTDTC}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check compares death date in AE AEDTHDT with death date in
DS DSSTDTC. It is expected that they are the same.
}
\examples{

AE <- data.frame(
 STUDYID = rep(1, 3),
 USUBJID = 1:3,
 AEDTHDTC = c("2020-01-01","2020-01-02","2020-01-03"),
 AESPID = "FORMNAME-R:19/L:19XXXX"
)

DS <- data.frame(
 STUDYID = rep(1, 3),
 USUBJID = 1:3,
 DSDECOD = rep("DEATH", 3),
 DSSTDTC = c("2020-01-01","2020-01-02","2020-01-03"),
 DSSPID = "XXX-R:0",
 stringsAsFactors = FALSE
)

# no case
check_dd_ae_aedthdtc_ds_dsstdtc(AE, DS)

# 1 case
DS[3, "DSSTDTC"] <- "2000-01-01"
check_dd_ae_aedthdtc_ds_dsstdtc(AE, DS, preproc=roche_derive_rave_row)

# check for non existence of vars
DS$DSDECOD <- NULL
DS$DSSTDTC <- NULL
check_dd_ae_aedthdtc_ds_dsstdtc(AE, DS)

}
\author{
Hiral Raval
}
