% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ds_duplicate_randomization.R
\name{check_ds_duplicate_randomization}
\alias{check_ds_duplicate_randomization}
\title{Check for duplicate randomization records for a patient}
\usage{
check_ds_duplicate_randomization(DS)
}
\arguments{
\item{DS}{Disposition SDTM dataset with variables USUBJID, DSDECOD}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
Checks for duplicate subject IDs (USUBJID) in the DS domain when
randomization is indicated
}
\examples{

DS <- data.frame(
 USUBJID = c("ID1","ID1","ID2","ID2","ID3","ID3"),
 DSDECOD = c("RANDOMIZATION","OTHER THING","RANDOMIZATION",
             "OTHER THING","RANDOMIZATION","RANDOMIZATION")
             , stringsAsFactors = FALSE
)

check_ds_duplicate_randomization(DS)

DS$DSDECOD <- NULL
check_ds_duplicate_randomization(DS)

}
\author{
Madeleine Ma
}
