% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ds_multdeath_dsstdtc.R
\name{check_ds_multdeath_dsstdtc}
\alias{check_ds_multdeath_dsstdtc}
\title{Check DS with multiple death records with death dates, where death dates do not match}
\usage{
check_ds_multdeath_dsstdtc(DS, preproc = identity, ...)
}
\arguments{
\item{DS}{Disposition SDTMv dataset with variables USUBJID, DSDECOD, and DSSTDTC}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
Boolean value for whether the check passed or failed, with 'msg'
attribute if the test failed
}
\description{
This check looks for patients in DS who have multiple records indicating
death, with non-missing mismatching death dates in DSSTDTC.
}
\examples{

DS_error1 <- data.frame(STUDYID = rep(1, 6),
  USUBJID = c(1, 1, 1, 2, 1,1),
  DSDECOD = c("DEATH", "DEATH", rep("", 2),"DEATH","DEATH"),
  DSSCAT = LETTERS[1:6],
  DSSTDTC = c("", "2016-01-01", "", "", "2016-01-02","2016-01-01"),
  stringsAsFactors = FALSE)

DS_error2 <- data.frame(STUDYID = rep(1, 6),
  USUBJID = c(1, 1, 1, 2, 1,1),
  DSDECOD = c("DEATH", "DEATH", rep("", 2),"DEATH","DEATH"),
  DSSCAT = LETTERS[1:6],
  DSSTDTC = c("", "2016-01", "", "", "2016-01-01","2016-01-01"),
  stringsAsFactors = FALSE)
  
 DS_noerror <- data.frame(STUDYID = rep(1, 6),
                        USUBJID = c(1, 1, 1, 2, 1,1),
                        DSDECOD = c("DEATH", "DEATH", rep("", 2),"DEATH","DEATH"),
                        DSSCAT = LETTERS[1:6],
                        DSSTDTC = c("", "2016-01-01", "", "", "2016-01-01","2016-01-01"),
                        stringsAsFactors = FALSE)

check_ds_multdeath_dsstdtc(DS_error1)
check_ds_multdeath_dsstdtc(DS_error2)
check_ds_multdeath_dsstdtc(DS_noerror)
}
\author{
Kimberly Fernandes
}
