% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_lb_lbdtc_after_dd.R
\name{check_lb_lbdtc_after_dd}
\alias{check_lb_lbdtc_after_dd}
\title{Check for LB dates occurring after death date}
\usage{
check_lb_lbdtc_after_dd(AE, DS, LB)
}
\arguments{
\item{AE}{Adverse Event SDTM dataset with variables USUBJID,
AEDTHDTC, AESTDTC, AEDECOD, and AETERM}

\item{DS}{Disposition SDTM dataset with variables USUBJID,
DSSTDTC, DSDECOD, and DSTERM}

\item{LB}{Laboratory Test Findings SDTM dataset with variables USUBJID,
LBDTC, LBTESTCD, and LBORRES}
}
\value{
Boolean value for whether the check passed or failed, with 'msg'
attribute if the check failed
}
\description{
This check looks for LB dates that occur after death date
}
\examples{

AE <- data.frame(STUDYID = 1:5, USUBJID = LETTERS[1:5],
                 AEDTHDTC = c(rep("", 4), "2016-01-01"),
                 AESTDTC = rep("2016-01-01", 5),
                 AEDECOD = LETTERS[1:5], AETERM = LETTERS[1:5],
                 stringsAsFactors = FALSE)

DS <- data.frame(STUDYID = 1:5, USUBJID = LETTERS[1:5],
                 DSSTDTC = rep("2016-01-02", 5),
                 DSDECOD = c(LETTERS[1:4], "death"),
                 DSTERM = letters[1:5],
                 stringsAsFactors = FALSE)

LB <- data.frame(STUDYID = 1:5, USUBJID = LETTERS[1:5],
                 LBDTC = rep("2015-12-31", 5),
                 LBTESTCD = letters[1:5],
                 LBORRES = 1:5,
                 stringsAsFactors = FALSE)

check_lb_lbdtc_after_dd(AE, DS, LB)

LB$LBDTC[1] <- "2016-01-03"
LB$USUBJID[1] <- LB$USUBJID[5]

check_lb_lbdtc_after_dd(AE, DS, LB)


}
\author{
Nina Ting Qi
}
